# DX_CC6_CORE_HOST_SIDE makefile
# CRYS_ATP component
#

COMP_NAME := $(CRYS_ATP_ID)

#id's of the components this component depends on
$(COMP_NAME)_DEPEND_ON_APIS := $(SHARED_ATP_ID) $(SST_ID) $(INIT_ID) $(FLOW_ID) $(CRYS_ID) $(VOS_ID) $(CC6_GEN_ID) $(KMNG_ID)

#id's of the components whose objects are used by this component
$(COMP_NAME)_USE_OBJ_IDS :=  $(SHARED_ATP_ID)

#paths of this component API include directories
$(COMP_NAME)_API_INCL_PATH := \
	$(HOST_PATH)CRYS_ATP/ATP_TST_MAIN/tinc/ \
	$(HOST_PATH)CRYS_ATP/ATP_TST_UTIL/tinc \
	$(HOST_PATH)DX_SST6_API/inc/ \
	

#paths of the internal include directories
$(COMP_NAME)_INTERNAL_INCL_PATH := \
	$(HOST_PATH)CRYS_ATP/ATP_TST_UTIL/tinc/ \
	$(HOST_PATH)CRYS_ATP/AES/tinc/ \
	$(HOST_PATH)CRYS_ATP/C2/tinc/ \
	$(HOST_PATH)CRYS_ATP/DES/tinc/ \
	$(HOST_PATH)CRYS_ATP/DH/tinc/ \
	$(HOST_PATH)CRYS_ATP/ECC/tinc/ \
	$(HOST_PATH)CRYS_ATP/FLOW/tinc/ \
	$(HOST_PATH)CRYS_ATP/HASH/tinc/ \
	$(HOST_PATH)CRYS_ATP/HMAC/tinc/ \
	$(HOST_PATH)CRYS_ATP/OTF/tinc/ \
	$(HOST_PATH)CRYS_ATP/RC4/tinc/ \
	$(HOST_PATH)CRYS_ATP/RND/tinc/ \
	$(HOST_PATH)CRYS_ATP/RSA/tinc/ \
	$(HOST_PATH)SEP_ERRORS/ \
	$(BASE_PATH)Sep_ram/Flow/inc/ \
	$(BASE_PATH)Sep/Gen/inc/

#global flags for this component will be added here
#project-specific flags for this component should be added to $($(COMP_NAME)_SPECIFIC_CCFLAGS) outside of this makefile
$(COMP_NAME)_CCFLAGS := 

#the objects names without path or extension
$(COMP_NAME)_OBJ_NAMES := \
	CRYS_ATP_TST_AES_Acceptance \
	CRYS_ATP_TST_AES_Acceptance_test_vectors CRYS_ATP_TST_AES_MAIN \
	CRYS_ATP_TST_DES_MAIN CRYS_ATP_TST_DH_MAIN \
	CRYS_ATP_TST_Defines CRYS_ATP_TST_ECC_MAIN \
	CRYS_ATP_TST_HASH_MAIN CRYS_ATP_TST_HMAC_MAIN \
	CRYS_ATP_TST_RC4_MAIN CRYS_ATP_TST_RND_MAIN \
	CRYS_ATP_TST_RSA_MAIN CRYS_ATP_TST_menu \
	CRYS_ATP_TST_UTIL_Funcs \
	CRYS_ATP_TST_DES_Acceptance CRYS_ATP_TST_DES_Acceptance_test_vectors \
	CRYS_ATP_TST_DH_Acceptance CRYS_ATP_TST_DH_Acceptance_test_vectors \
	CRYS_ATP_TST_ECC_Acceptance CRYS_ATP_TST_ECC_Acceptance_test_vectors \
	CRYS_ATP_TST_HASH_Acceptance \
	CRYS_ATP_TST_HASH_Acceptance_test_vectors CRYS_ATP_TST_HMAC_Acceptance \
	CRYS_ATP_TST_HMAC_Acceptance_test_vectors CRYS_ATP_TST_RC4_Acceptance \
	CRYS_ATP_TST_RC4_Acceptance_test_vectors CRYS_ATP_TST_RND_Acceptance \
	CRYS_ATP_TST_RND_Acceptance_test_vectors CRYS_ATP_TST_RSA_Acceptance \
	CRYS_ATP_TST_RSA_Acceptance_test_vectors 

ifeq ($(CRYS_ATP_USE_FLOW),true)
	$(COMP_NAME)_OBJ_NAMES += CRYS_ATP_TST_AESFLOW_Acceptance CRYS_ATP_TST_AESFLOW_Acceptance_test_vectors \
		CRYS_ATP_TST_DESFLOW_Acceptance CRYS_ATP_TST_DESFLOW_Acceptance_test_vectors \
		CRYS_ATP_TST_FLOW_Acceptance CRYS_ATP_TST_FLOW_MAIN \
		CRYS_ATP_TST_HASHFLOW_Acceptance CRYS_ATP_TST_HASHFLOW_Acceptance_test_vectors \
		CRYS_ATP_TST_HMACFLOW_Acceptance CRYS_ATP_TST_HMACFLOW_Acceptance_test_vectors \
		CRYS_ATP_TST_RC4FLOW_Acceptance CRYS_ATP_TST_RC4FLOW_Acceptance_test_vectors
endif

$(COMP_NAME)_MAIN_OBJ_NAMES := \
	CRYS_ATP_TST_main

#Use the above specific settings for building the components properties with the standard rules:
include $(MF_PATH)CC6_STD_RULES.inc

##  OBJECT RULES - ADD RULES FOR NEW SOURCE FILES
#   make sure to add obj_name to the above list: $(COMP_NAME)_OBJS
#   this is the template for rules:
#$(OUT_OBJ_PATH)<<OBJ_NAME>>.$(OBJEXT): $(HOST_PATH)<<SOURCE_PATH>>
#	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@


$(OUT_OBJ_PATH)CRYS_ATP_TST_AES_Acceptance.$(OBJEXT): $(HOST_PATH)CRYS_ATP/AES/tsrc/CRYS_ATP_TST_AES_Acceptance.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_AES_Acceptance_test_vectors.$(OBJEXT): $(HOST_PATH)CRYS_ATP/AES/tsrc/CRYS_ATP_TST_AES_Acceptance_test_vectors.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_AES_MAIN.$(OBJEXT): $(HOST_PATH)CRYS_ATP/ATP_TST_MAIN/tsrc/CRYS_ATP_TST_AES_MAIN.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_DES_MAIN.$(OBJEXT): $(HOST_PATH)CRYS_ATP/ATP_TST_MAIN/tsrc/CRYS_ATP_TST_DES_MAIN.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_DH_MAIN.$(OBJEXT): $(HOST_PATH)CRYS_ATP/ATP_TST_MAIN/tsrc/CRYS_ATP_TST_DH_MAIN.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_Defines.$(OBJEXT): $(HOST_PATH)CRYS_ATP/ATP_TST_MAIN/tsrc/CRYS_ATP_TST_Defines.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_ECC_MAIN.$(OBJEXT): $(HOST_PATH)CRYS_ATP/ATP_TST_MAIN/tsrc/CRYS_ATP_TST_ECC_MAIN.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_HASH_MAIN.$(OBJEXT): $(HOST_PATH)CRYS_ATP/ATP_TST_MAIN/tsrc/CRYS_ATP_TST_HASH_MAIN.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_HMAC_MAIN.$(OBJEXT): $(HOST_PATH)CRYS_ATP/ATP_TST_MAIN/tsrc/CRYS_ATP_TST_HMAC_MAIN.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_RC4_MAIN.$(OBJEXT): $(HOST_PATH)CRYS_ATP/ATP_TST_MAIN/tsrc/CRYS_ATP_TST_RC4_MAIN.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_RND_MAIN.$(OBJEXT): $(HOST_PATH)CRYS_ATP/ATP_TST_MAIN/tsrc/CRYS_ATP_TST_RND_MAIN.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_RSA_MAIN.$(OBJEXT): $(HOST_PATH)CRYS_ATP/ATP_TST_MAIN/tsrc/CRYS_ATP_TST_RSA_MAIN.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_main.$(OBJEXT): $(HOST_PATH)CRYS_ATP/ATP_TST_MAIN/tsrc/CRYS_ATP_TST_main.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_menu.$(OBJEXT): $(HOST_PATH)CRYS_ATP/ATP_TST_MAIN/tsrc/CRYS_ATP_TST_menu.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_UTIL_Funcs.$(OBJEXT): $(HOST_PATH)CRYS_ATP/ATP_TST_UTIL/tsrc/CRYS_ATP_TST_UTIL_Funcs.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_DES_Acceptance.$(OBJEXT): $(HOST_PATH)CRYS_ATP/DES/tsrc/CRYS_ATP_TST_DES_Acceptance.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_DES_Acceptance_test_vectors.$(OBJEXT): $(HOST_PATH)CRYS_ATP/DES/tsrc/CRYS_ATP_TST_DES_Acceptance_test_vectors.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_DH_Acceptance.$(OBJEXT): $(HOST_PATH)CRYS_ATP/DH/tsrc/CRYS_ATP_TST_DH_Acceptance.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_DH_Acceptance_test_vectors.$(OBJEXT): $(HOST_PATH)CRYS_ATP/DH/tsrc/CRYS_ATP_TST_DH_Acceptance_test_vectors.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_ECC_Acceptance.$(OBJEXT): $(HOST_PATH)CRYS_ATP/ECC/tsrc/CRYS_ATP_TST_ECC_Acceptance.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_ECC_Acceptance_test_vectors.$(OBJEXT): $(HOST_PATH)CRYS_ATP/ECC/tsrc/CRYS_ATP_TST_ECC_Acceptance_test_vectors.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_HASH_Acceptance.$(OBJEXT): $(HOST_PATH)CRYS_ATP/HASH/tsrc/CRYS_ATP_TST_HASH_Acceptance.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_HASH_Acceptance_test_vectors.$(OBJEXT): $(HOST_PATH)CRYS_ATP/HASH/tsrc/CRYS_ATP_TST_HASH_Acceptance_test_vectors.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_HMAC_Acceptance.$(OBJEXT): $(HOST_PATH)CRYS_ATP/HMAC/tsrc/CRYS_ATP_TST_HMAC_Acceptance.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_HMAC_Acceptance_test_vectors.$(OBJEXT): $(HOST_PATH)CRYS_ATP/HMAC/tsrc/CRYS_ATP_TST_HMAC_Acceptance_test_vectors.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_RC4_Acceptance.$(OBJEXT): $(HOST_PATH)CRYS_ATP/RC4/tsrc/CRYS_ATP_TST_RC4_Acceptance.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_RC4_Acceptance_test_vectors.$(OBJEXT): $(HOST_PATH)CRYS_ATP/RC4/tsrc/CRYS_ATP_TST_RC4_Acceptance_test_vectors.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_RND_Acceptance.$(OBJEXT): $(HOST_PATH)CRYS_ATP/RND/tsrc/CRYS_ATP_TST_RND_Acceptance.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_RND_Acceptance_test_vectors.$(OBJEXT): $(HOST_PATH)CRYS_ATP/RND/tsrc/CRYS_ATP_TST_RND_Acceptance_test_vectors.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_RSA_Acceptance.$(OBJEXT): $(HOST_PATH)CRYS_ATP/RSA/tsrc/CRYS_ATP_TST_RSA_Acceptance.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_RSA_Acceptance_test_vectors.$(OBJEXT): $(HOST_PATH)CRYS_ATP/RSA/tsrc/CRYS_ATP_TST_RSA_Acceptance_test_vectors.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_FLOW_MAIN.$(OBJEXT): $(HOST_PATH)CRYS_ATP/ATP_TST_MAIN/tsrc/CRYS_ATP_TST_FLOW_MAIN.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_AESFLOW_Acceptance.$(OBJEXT): $(HOST_PATH)CRYS_ATP/FLOW/tsrc/CRYS_ATP_TST_AESFLOW_Acceptance.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_AESFLOW_Acceptance_test_vectors.$(OBJEXT): $(HOST_PATH)CRYS_ATP/FLOW/tsrc/CRYS_ATP_TST_AESFLOW_Acceptance_test_vectors.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_DESFLOW_Acceptance.$(OBJEXT): $(HOST_PATH)CRYS_ATP/FLOW/tsrc/CRYS_ATP_TST_DESFLOW_Acceptance.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_DESFLOW_Acceptance_test_vectors.$(OBJEXT): $(HOST_PATH)CRYS_ATP/FLOW/tsrc/CRYS_ATP_TST_DESFLOW_Acceptance_test_vectors.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_FLOW_Acceptance.$(OBJEXT): $(HOST_PATH)CRYS_ATP/FLOW/tsrc/CRYS_ATP_TST_FLOW_Acceptance.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_HASHFLOW_Acceptance.$(OBJEXT): $(HOST_PATH)CRYS_ATP/FLOW/tsrc/CRYS_ATP_TST_HASHFLOW_Acceptance.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_HASHFLOW_Acceptance_test_vectors.$(OBJEXT): $(HOST_PATH)CRYS_ATP/FLOW/tsrc/CRYS_ATP_TST_HASHFLOW_Acceptance_test_vectors.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_HMACFLOW_Acceptance.$(OBJEXT): $(HOST_PATH)CRYS_ATP/FLOW/tsrc/CRYS_ATP_TST_HMACFLOW_Acceptance.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_HMACFLOW_Acceptance_test_vectors.$(OBJEXT): $(HOST_PATH)CRYS_ATP/FLOW/tsrc/CRYS_ATP_TST_HMACFLOW_Acceptance_test_vectors.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_RC4FLOW_Acceptance.$(OBJEXT): $(HOST_PATH)CRYS_ATP/FLOW/tsrc/CRYS_ATP_TST_RC4FLOW_Acceptance.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CRYS_ATP_TST_RC4FLOW_Acceptance_test_vectors.$(OBJEXT): $(HOST_PATH)CRYS_ATP/FLOW/tsrc/CRYS_ATP_TST_RC4FLOW_Acceptance_test_vectors.c
	$(CRYS_ATP_CC_CMD) $< $(CCFLAG_OUTPUT) $@

